--> NOTA : le gouverneur de ressources n'est apparu qu' partir de la version 2008 de SQL Server

USE master;
GO

CREATE RESOURCE POOL RP_REPORT
   WITH (MAX_CPU_PERCENT = 20,
         MAX_MEMORY_PERCENT = 20);
GO

CREATE WORKLOAD GROUP WG_DAF
WITH (IMPORTANCE = MEDIUM,
      MAX_DOP = 2,
      GROUP_MAX_REQUESTS = 5)
USING RP_REPORT;
GO

CREATE WORKLOAD GROUP WG_PDG
WITH (IMPORTANCE = HIGH,
      MAX_DOP = 4,
      GROUP_MAX_REQUESTS = 2)
USING RP_REPORT;
GO

CREATE FUNCTION dbo.RESOURCE_CLASSIFIER()
RETURNS SYSNAME
WITH SCHEMABINDING
AS
BEGIN
   DECLARE @WORKLOAD SYSNAME
   IF APP_NAME() = 'report system'
      IF SYSTEM_USER = 'bill.gates\microsoft.com'
         SET @WORKLOAD = 'WG_PDG';
      ELSE
         SET @WORKLOAD = 'WG_DAF';
   RETURN @WORKLOAD;
END
GO

ALTER RESOURCE GOVERNOR
   WITH (CLASSIFIER_FUNCTION = dbo.RESOURCE_CLASSIFIER);
GO

--> ATTENTION : une erreur c'est glisse dans la version imprime. Il faut lire "RP_REPORT" et non "RP_1" pour les deux commandes "CREATE WORKLOAD GROUP". Le prsent script corrige cette erreur.